<?php

namespace Ignite\Catalog\Http\Controllers\Api;

use Illuminate\Http\Request;
use Ignite\Catalog\Entities\Item;
use Ignite\Catalog\Entities\Option;
use Ignite\Core\Http\Controllers\Controller;

class OptionsController extends Controller
{
    /**
     * Search for matching items to use for options on a configurable.
     *
     * @param  Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $query = $request->input('q');
        $results = Item::query()->where('sku', 'like', "{$query}_%")->get();

        return response()->json($results);
    }

    /**
     * Show the options for a single item.
     *
     * @param  Item $item
     * @return \Illuminate\Http\JsonResponse
     */
    public function show(Item $item)
    {
        $options = Option::with(['item', 'attribute'])
            ->where('super_id', $item->id)
            ->orderBy('position', 'ASC')
            ->get();

        $grouped = $options
            ->groupBy('attribute.code')
            ->map(function($options) use ($item) {
                return [
                    'attribute' => $options->first()->attribute,
                    'options' => $options,
                    'search' => "{$item->sku}_",
                    'errors' => []
                ];
            });

        return response()->json($grouped);
    }
}
