<?php

namespace Ignite\Catalog\Events\Subscribers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Ignite\Catalog\Emails\OrderSubmitted;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Ignite\Catalog\Events\OrderEvent;
use Ignite\Core\Entities\User;

class OrderEventSubscriber
{
    /**
     * Handle order shipped event.
     *
     * @param  OrderEvent $event
     */
    public function onShipped(OrderEvent $event)
    {

    }


    /**
     * Handle order submitted event.
     *
     * @param OrderEvent $event
     *
     * @return bool
     */
    public function onSubmitted(OrderEvent $event)
    {
        if (app()->runningInConsole() && ! config('site.demo.allow_events_in_console')) {
            return false;
        }

        Mail::later(now()->addSeconds(30), new OrderSubmitted($event->order));
    }

    /**
     * Handle order cancelled event.
     *
     * @param  OrderEvent $event
     */
    public function onCancelled($event)
    {
        //
    }

    /**
     * Register the listeners for the subscriber.
     *
     * @param  \Illuminate\Events\Dispatcher $events
     */
    public function subscribe($events)
    {
        $events->listen(
            'Ignite\Catalog\Events\OrderEvent',
            'Ignite\Catalog\Events\Subscribers\OrderEventSubscriber@onSubmitted'
        );
    }
}
