<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Catalog\Entities\Category;
use Ignite\Core\Database\Seeders\AbstractSeeder;

class CatalogCategoryTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => realpath(__DIR__ . '/../Data/catalog_category.json'),
            'headers' => true
        ]);

        $categories = $strategy->run();

        try {
            foreach ($categories as $category) {
                Category::updateOrCreate([
                    'code' => $category['code']
                ], $category);
            }
        } catch (\Exception $e) {

        }
    }
}
