<?php

return [
    'name' => 'Catalog',

    'disk' => 's3',

    'redirect_when_only_one' => false,
    'display_type_ribbon' => false,
    'default_point_value' => '0.05',
    'default_price_margin' => '13.04',

    'order' => [
        'prefix' => env('CATALOG_ORDER_PREFIX', 'IG'),
        'padding' => env('CATALOG_ORDER_PADDING', 10)
    ],

    'vendors' => [
        'hawk' => [
            'merchant_id' => env('CATALOG_HAWK_MERCHANT_ID'),
            'cert' => base_path(env('CATALOG_HAWK_CERT')),
            'key' => base_path(env('CATALOG_HAWK_KEY')),
            'test_product_id' => env('CATALOG_HAWK_TEST_PRODUCT_ID'),
            'egift' => [
                'senderName' => 'Ignite Rewards',
                'senderEmail' => 'it@brightspot.email',
                'subject' => 'Catalog Rewards - eGift Order',
                'emailMessage' => env('CATALOG_HAWK_EGIFT_MESSAGE', ''),
                'emailClosingName' => 'Reward Headquarters',
            ],
            'company' => 'Ignite Catalog Rewards',
            'address1' => '102 Decker Ct Suite 150',
            'city' => 'Irving',
            'state' => 'TX',
            'zip' => '75062',
            'country' => 'US',
            'unsubscribe' => [
                'type' => 'EMAIL',
                'value' => 'support@ttlrewards.com'
            ],
            'schema' => [
                [
                    'name' => 'product_id',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Product ID'
                ], [
                    'name' => 'content_provider_code',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Content Provider Code'
                ]
            ]
        ],
        'hinda' => [
            'schema' => [
                [
                    'name' => 'product_id',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Product ID'
                ], [
                    'name' => 'catalog_number',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Catalog Number'
                ]
            ]
        ],
        'brightspot' => [
            "name" => "brightspot",
            "type" => "merchandise",
            "image_path" => "catalog/brightspot",
            "vendor_countries" => "US",
            "redemption_class" => "\Ignite\Catalog\Vendors\NullProcessor",
            "active" => 1
        ]
    ],

    'brightspot' => [
        "name" => "International Merchandise Catalog",
        "code" => "brightspot",
        "type" => "merchandise",
        "description" => "Example International merchandise catalog.",
        "countries" => "US",
        "active" => 1,
    ]
];
