<?php

namespace Ignite\Catalog\Tests\Unit\Models\Hawk;

use Ignite\Catalog\Models\Hawk\Ssl;
use Ignite\Tests\TestCase;

class SslTest extends TestCase
{
    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_store_and_retrieve_references_to_paths_to_ssl_cert_and_key_files_on_disk()
    {
        $path = realpath(__DIR__ . '/../../../../../../storage/certs');

        $data = [
            'certPath' => $path . '/brightspot.cert.pem',
            'keyPath' => $path . '/brightspot.key'
        ];

        $ssl = new Ssl($data['certPath'], $data['keyPath']);

        $this->assertSame([$data['certPath'], $data['keyPath']], $ssl->forHttpClient());
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_throws_an_exception_when_the_certPath_argument_is_invalid()
    {
        $path = realpath(__DIR__ . '/../../../../../../storage/certs');

        $data = [
            'certPath' => '/brightspot.cert.pem',
            'keyPath' => $path . '/brightspot.key'
        ];

        new Ssl($data['certPath'], $data['keyPath']);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_throws_an_exception_when_the_keyPath_argument_is_invalid()
    {
        $path = realpath(__DIR__ . '/../../../../../../storage/certs');

        $data = [
            'certPath' => $path . '/brightspot.cert.pem',
            'keyPath' => '/brightspot.key'
        ];

        new Ssl($data['certPath'], $data['keyPath']);
    }
}
