@extends('Catalog::layouts.master')

@section('page_heading', trans('Catalog::item.misc.create.heading', ['type' => 'new']))
@section('page_breadcrumb', trans('Catalog::item.misc.create.heading', ['type' => 'new']))

@section('page_content')

    <div class="row">
        <div class="col-sm-4 col-sm-offset-4">
            <form class="form-horizontal" method="GET" action="{{ route('admin.catalog.items.create') }}">
            @component('Core::admin.components.box')
                @slot('title')
                    {{ trans('Catalog::item.misc.type.choose') }}
                @endslot
                    <div class="form-group">
                        <label for="type" class="col-sm-4">{{ trans('Catalog::item.fields.type.label') }}</label>
                        <div class="col-sm-8">
                            <select id="type" class="form-control" name="type">
                                <option value="simple">{{ trans('Catalog::item.misc.type.simple') }}</option>
                                <option value="configurable">{{ trans('Catalog::item.misc.type.configurable') }}</option>
                            </select>
                        </div>
                    </div>
                @slot('footer')
                    <button class="btn btn-primary pull-right">{{ trans('Core::core.buttons.continue') }}</button>
                @endslot
            @endcomponent
            </form>
        </div>
    </div>

@endsection
