<?php

namespace Ignite\Catalog\Models\Dashboard\Charts;

use Illuminate\Support\Facades\DB;
use Ignite\Core\Models\Dashboard\Table;

class MostFavoritedItemsTable extends Table
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'label'   => 'Most Favorited Items',
            'color'   => 'primary',
            'icon'    => 'ion ion-heart',
            'sort'    => 3,
            'headers' => $this->getHeaders()
        ], $attributes);

        parent::__construct($attributes);
    }

    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'favorited-items-list';
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-12 col-sm-4');
    }

    /**
     * Get the correct data value from storage.
     *
     * @return mixed
     */
    public function getData()
    {
        if (! $this->get('data', false)) {
            /**
             * @var \Carbon\Carbon $start
             * @var \Carbon\Carbon $end
             */
            list($start, $end) = $this->getDateRange();

            $this->attributes['data'] = DB::query()
                ->select(
                    DB::raw('COUNT(catalog_favorite.item_id) as total'),
                    'catalog_favorite.item_id as item_id',
                    DB::raw('CONCAT(catalog_vendor.image_path, "/", catalog_item.image) as image'),
                    'catalog_item.name as name'
                )
                ->from('catalog_favorite')
                ->leftJoin('catalog_item', 'catalog_favorite.item_id', '=', 'catalog_item.id')
                ->leftJoin('catalog_vendor', 'catalog_item.catalog_vendor_id', '=', 'catalog_vendor.id')
                ->whereBetween('catalog_favorite.created_at', [$start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')])
                ->groupBy('catalog_favorite.item_id', 'catalog_item.name', 'catalog_vendor.image_path')
                ->orderBy('total', 'desc')
                ->take(5)
                ->get();
        }

        return $this->get('data');
    }

    /**
     * The table headers, if any.
     *
     * @return array
     */
    public function getHeaders()
    {
        return [];
    }
}
