<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Catalog\Entities\Catalog;
use Ignite\Core\Database\Seeders\AbstractSeeder;

class CatalogTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('catalog.json')
        ]);

        $catalogs = $strategy->run();

        foreach ($catalogs as $catalog) {
            try {
                Catalog::create($catalog);
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
