<?php

namespace Ignite\Catalog\Http\Forms;

use Kris\LaravelFormBuilder\Form;

class AttributeForm extends Form
{
    /**
     * Build the form.
     *
     * @return self
     */
    public function buildForm()
    {
        $this->add('label', 'text', $this->getLabelOptions());
        $this->add('code', 'text', $this->getCodeOptions());
        $this->add('type', 'select', $this->getTypeOptions());
        //$this->add('use_in_filter', 'toggle', $this->getUseInFilterOptions());
        $this->add('submit', 'submit', $this->getSaveButtonOptions());

        return $this;
    }

    /**
     * The options for the label field.
     *
     * @return array
     */
    protected function getLabelOptions()
    {
        return [
            'label' => trans('Catalog::attribute.fields.label.label'),
            'rules' => 'required|min:2|max:255'
        ];
    }

    /**
     * The options for the code field.
     *
     * @return array
     */
    protected function getCodeOptions()
    {
        return [
            'label' => trans('Catalog::attribute.fields.code.label'),
            'rules' => 'required|min:2|max:255'
        ];
    }

    /**
     * The options for the type field.
     *
     * @return array
     */
    protected function getTypeOptions()
    {
        return [
            'label' => trans('Catalog::attribute.fields.type.label'),
            'rules' => 'max:50',
            'attr' => ['class' => 'select2'],
            'choices' => [
                'select' => 'select',
            ]
        ];
    }

    /**
     * The options for the save button.
     *
     * @return array
     */
    protected function getUseInFilterOptions()
    {
        return [
            'label' => trans('Catalog::attribute.fields.use_in_filter.label')
        ];
    }

    /**
     * The options for the save button.
     *
     * @return array
     */
    protected function getSaveButtonOptions()
    {
        return [
            'attr' => ['class' => 'btn btn-primary'],
            'label' => trans('Catalog::attribute.fields.save.label')
        ];
    }
}
