<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCatalogCartItemTable extends Migration
{
    protected $tableName = 'catalog_cart_item';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id');
            $table->unsignedInteger('catalog_id');
            $table->unsignedInteger('catalog_vendor_id');
            $table->unsignedInteger('super_id')->nullable()->default();
            $table->unsignedInteger('item_id');
            $table->unsignedInteger('quantity')->nullable()->default();
            $table->unsignedInteger('price')->default(0);
            $table->unsignedInteger('points')->default(0);
            $table->timestamps();
            $table->foreign('user_id')->references('user_id')->on('core_user');
            $table->foreign('catalog_id')->references('id')->on('catalog');
            $table->foreign('catalog_vendor_id')->references('id')->on('catalog_vendor');
            $table->foreign('super_id')->references('id')->on('catalog_item');
            $table->foreign('item_id')->references('id')->on('catalog_item');
            $table->unique(['id', 'item_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
