<?php

namespace Ignite\Catalog\Events\Handlers\Menus;

use Ignite\Core\Events\Menus\ParticipantMenuPreCompile;

class AddCatalogToParticipantPanel
{
    /**
     * Handle the event.
     *
     * @param ParticipantMenuPreCompile $event
     */
    public function handle(ParticipantMenuPreCompile $event)
    {
        $event->getManager()->merge(
            $event->getManager()->hydrateItems(
                $this->getItems($event->getParticipantId())
            )
        );
    }

    /**
     * Get the items to merge with the menu.
     *
     * @param  int $participantId
     * @return \Illuminate\Support\Collection
     */
    protected function getItems($participantId)
    {
        return collect([
            [
                'position' => 12,
                'url' => route('admin.participant.orders', ['participant' => $participantId]),
                'label' => 'Orders',
                'icon' => 'shopping-basket',
                'allow' => auth()->user()->can('core.user.orders.browse'),
                'badge' => $this->countOrders($participantId)
            ],
        ]);
    }

    /**
     * Count the number of order entries for the participant.
     *
     * @param  int $participantId
     * @return array
     */
    protected function countOrders($participantId)
    {
        return app(\Ignite\Catalog\Entities\Order::class)
            ->query()
            ->where('user_id', $participantId)
            ->count();
    }
}