<?php

namespace Ignite\Catalog\Events\Handlers\Menus;

use Ignite\Core\Events\Menus\AdminMenuPreCompile;

class AddCatalogMenu
{
    /**
     * Handle the event.
     *
     * @param AdminMenuPreCompile $event
     */
    public function handle(AdminMenuPreCompile $event)
    {
        $event->getManager()->merge(
            $event->getManager()->hydrateItems(
                $this->getItems()
            )
        );
    }

    /**
     * The menu items in their raw format.
     *
     * @return \Illuminate\Support\Collection
     */
    private function getItems()
    {
        return collect([
            [
                'position' => 60,
                'url' => '/admin/catalog',
                'label' => 'Catalog',
                'icon' => 'trophy',
                'allow' => auth()->user()->can('catalog.browse'),
                'children' => [
                    [
                        'position' => 1,
                        'url'   => route('admin.catalog.items.index'),
                        'label'  => 'Items',
                        'icon' => 'archive',
                        'allow' => 'catalog.item.browse',
                    ],
                    [
                        'position' => 2,
                        'url'   => route('admin.catalog.orders.index'),
                        'label'  => 'Orders',
                        'icon' => 'cart-arrow-down',
                        'allow' => auth()->user()->can('catalog.order.browse'),
                    ],
                    [
                        'position' => 2,
                        'url' => route('admin.catalog.vendors.index'),
                        'label' => 'Vendors',
                        'icon' => 'handshake-o',
                        'allow' => auth()->user()->can('catalog.vendor.browse'),
                    ],
                    [
                        'position' => 3,
                        'url' => route('admin.catalog.index'),
                        'label' => 'Catalogs',
                        'icon' => 'book',
                        'allow' => auth()->user()->can('catalog.catalog.browse'),
                    ],
                    [
                        'position' => 4,
                        'url' => route('admin.catalog.attributes.index'),
                        'label' => 'Attributes',
                        'icon' => 'tags',
                        'allow' => auth()->user()->can('catalog.attributes.browse'),
                    ],
                    [
                        'position' => 5,
                        'url' => route('admin.catalog.categories.index'),
                        'label' => 'Categories',
                        'icon' => 'sitemap',
                        'allow' => auth()->user()->can('catalog.categories.browse'),
                    ],
                    [
                        'position' => 6,
                        'url' => route('admin.catalog.menus.index'),
                        'label' => 'Menus',
                        'icon' => 'list-ol',
                        'allow' => auth()->user()->can('catalog.menu.browse'),
                    ],
                ],
            ]
        ]);
    }
}
