<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
//use Ignite\Core\Database\IgniteMigration;

class CreateCatalogMenuItemTable extends Migration
{
    protected $tableName = 'catalog_menu_item';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('catalog_menu_id');
            $table->unsignedInteger('catalog_category_id');
            $table->unsignedInteger('parent_id');
            $table->unsignedInteger('position');
            $table->boolean('active')->default(0);
            $table->timestamps();
            $table->foreign('catalog_menu_id')->references('id')->on('catalog_menu');
            $table->foreign('catalog_category_id')->references('id')->on('catalog_category');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
