<?php

namespace Ignite\Catalog\Contracts;

use Illuminate\Support\Collection;

interface AttributeRepository
{
    /**
     * The default query builder.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * Find a attribute by id.
     *
     * @param  int  $id
     * @return \Ignite\Catalog\Entities\Attribute
     */
    public function find($id);

    /**
     * Create a attribute.
     *
     * @param  Collection  $data
     * @return \Ignite\Catalog\Entities\Attribute
     */
    public function create(Collection $data);

    /**
     * Update a attribute.
     *
     * @param  int  $id
     * @param  Collection  $data
     * @return \Ignite\Catalog\Entities\Attribute
     */
    public function update(int $id, Collection $data);

    /**
     * Delete a attribute and any associated data.
     *
     * @param  int  $id
     * @return \Ignite\Catalog\Entities\Attribute
     */
    public function delete(int $id);

    /**
     * Delete many attributes and any associated data.
     *
     * @param  array  $ids
     * @return array
     */
    public function deleteMany(array $ids);
}
