<?php
namespace Ignite\Catalog\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class OrderEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $orderData = $this->data;
        $emailSettings = (! empty($this->data['email_settings'])) ? $this->data['email_settings'] : [];

        $this->to($emailSettings['toEmail']);
        $this->bcc(config('mail.from.address'), config('mail.from.name'));

        if (! empty($emailSettings['subject'])) {
            $this->subject($emailSettings['subject']);
        }

        if (! empty($emailSettings['from'])) {
            $this->subject($emailSettings['from']);
        }

        // return $this->view($emailSettings['template'])->with('orderData', $orderData);
        return $this->markdown($emailSettings['template'])->with('orderData', $orderData);
    }
}
