<?php

namespace Ignite\Catalog\Repositories;

use Illuminate\Support\Collection;
use Ignite\Catalog\Entities\Attribute;
use Ignite\Catalog\Entities\AttributeItem;
use Ignite\Catalog\Entities\Option;

class AttributeRepository implements \Ignite\Catalog\Contracts\AttributeRepository
{
    /**
     * The default query builder.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        return Attribute::query();
    }

    /**
     * Find a attribute by id.
     *
     * @param  int  $id
     * @return Attribute
     */
    public function find($id)
    {
        return Attribute::findOrFail($id);
    }

    /**
     * Create a attribute.
     *
     * @param  Collection  $data
     * @return Attribute
     */
    public function create(Collection $data)
    {
        $attribute = Attribute::create($data->toArray());

        return $attribute;
    }

    /**
     * Update a attribute.
     *
     * @param  int  $id
     * @param  Collection  $data
     * @return Attribute
     */
    public function update(int $id, Collection $data)
    {
        // TODO: Implement update() method.
    }

    /**
     * Delete a attribute and any associated data.
     *
     * @param  int  $id
     * @return Attribute
     */
    public function delete(int $id)
    {
        $attribute = $this->find($id);

        app('db')->transaction(function () use ($attribute) {
            Option::query()->where('attribute_id', $attribute->getKey())->delete();
            AttributeItem::query()->where('attribute_id', $attribute->getKey())->delete();

            return $attribute->delete();
        });

        return $attribute;
    }

    /**
     * Delete many attributes and any associated data.
     *
     * @param  array  $ids
     * @return array
     */
    public function deleteMany(array $ids)
    {
        return app('db')->transaction(function () use ($ids) {
            Option::query()->whereIn('attribute_id', $ids)->delete();
            AttributeItem::query()->whereIn('attribute_id', $ids)->delete();
            return Attribute::query()->whereIn((new Attribute)->getKeyName(), $ids)->delete();
        });
    }
}
