<?php

namespace Ignite\Catalog\Traits;

use Ignite\Catalog\Entities\Cart;
use Ignite\Catalog\Entities\Order;

trait CatalogRelations
{
    /**
     * The relationship to catalog orders.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function orders()
    {
        return $this->hasMany(Order::class, 'user_id', 'user_id');
    }

    /**
     * The relationship to the catalog cart.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function cart()
    {
        return $this->hasMany(Cart::class, 'user_id', 'user_id');
    }
}
