<?php

namespace Ignite\Catalog\Http\Views;

use Illuminate\View\View;
use Ignite\Catalog\Models\Cart;

class PointsTotalComposer
{
    /**
     * @var Cart
     */
    private $cart;

    /**
     * CatalogCountsComposer constructor.
     *
     * @param Cart $cart
     */
    public function __construct(Cart $cart)
    {
        $this->cart = $cart;
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $view->with('balance', $this->cart->balance());
    }
}
