<?php

namespace Ignite\Catalog\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class OrderDeleteManyRequest extends FormRequest
{
    /**
     * Authorize the order create request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'ids' => 'required',
        ];

        return $rules;
    }

    /**
     * The customized messages.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'ids.required' => 'You must supply at least one record to delete.',
        ];
    }
}
