<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCatalogCategoryItemTable extends Migration
{
    protected $tableName = 'catalog_category_item';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('category_id');
            $table->unsignedInteger('item_id');
            $table->unsignedInteger('position');
            $table->timestamps();
            $table->foreign('category_id')->references('id')->on('catalog_category');
            $table->foreign('item_id')->references('id')->on('catalog_item');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
