<?php

namespace Ignite\Catalog\Tests\Unit\Models\Product\Types;

use Ignite\Catalog\Entities\Item;
use Ignite\Catalog\Models\Product\Types\Configurable;
use Ignite\Catalog\Tests\TestCase;

class ConfigurableTest extends TestCase
{
    public function setUp()
    {
        parent::setUp();
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Type
     */
    public function it_can_return_the_associated_item()
    {
        $configurable = new Configurable(new Item());

        $this->assertInstanceOf(Item::class, $configurable->getItem());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Type
     */
    public function it_will_return_the_max_points_as_a_formatted_amount_when_the_max_and_min_are_the_same()
    {
        $item = new Item();
        $item->forceFill([
            'points_min' => 100,
            'points_max' => 100,
        ]);
        $configurable = new Configurable($item);

        $this->assertSame('100', $configurable->getPointsRange());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Type
     */
    public function it_will_return_the_points_range_as_formatted_amounts_when_the_max_and_min_are_not_the_same()
    {
        $item = new Item();
        $item->forceFill([
            'points_min' => 100,
            'points_max' => 1000,
        ]);
        $configurable = new Configurable($item);

        $expected = '100 <span class="points__dash">&ndash;</span> 1,000';

        $this->assertSame($expected, $configurable->getPointsRange()->toHtml());
    }
}
