<?php

namespace Ignite\Catalog\Tests\Unit\Models\Options;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Ignite\Catalog\Models\Options\Vendors;
use Ignite\Catalog\Tests\TestCase;

class VendorsTest extends TestCase
{
    use RefreshDatabase;

    public function setUp()
    {
        parent::setUp();
    }

    /**
     * @test
     * @group Catalog
     * @group Options
     * @group Source
     */
    public function it_will_return_an_empty_array_when_no_vendor_records_exist()
    {
        $sourceModel = new Vendors();

        $this->assertEmpty($sourceModel->toDropdown());
    }

    /**
     * @test
     * @group Catalog
     * @group Options
     * @group Source
     */
    public function it_will_return_the_vendor_records_as_key_value_pair_for_use_in_a_dropdown()
    {
        $sourceModel = new Vendors();

        $vendor = factory(\Ignite\Catalog\Entities\Vendor::class)->create([
            'name' => 'Test'
        ]);

        $this->assertArrayHasKey($vendor->getKey(), $sourceModel->toDropdown());
        $this->assertContains($vendor->name, $sourceModel->toDropdown());
    }
}
