<?php

namespace Ignite\Catalog\Vendors\Hawk;

use Illuminate\Support\Collection;
use Ignite\Catalog\Contracts\VendorHandler;
use Ignite\Catalog\Entities\Order;
use Ignite\Catalog\Entities\Vendor;

class Egift implements VendorHandler
{
    /**
     * @var Vendor
     */
    private $vendor;

    /**
     * Egift constructor.
     *
     * @param Vendor $vendor
     */
    public function __construct(Vendor $vendor)
    {
        $this->vendor = $vendor;
    }

    /**
     * Handle the egift order items.
     *
     * @param  Order      $order
     * @param  Collection $orderItems
     */
    public function handle(Order $order, Collection $orderItems)
    {
        $count = 0;
        foreach ($orderItems as $orderItem) {
            if ($orderItem->item->vendor_active) {
                ++$count;
                dispatch(new \Ignite\Catalog\Jobs\Hawk\Egift($order, $orderItem))->delay($count);
            }
        }
    }
}
