<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Support\HtmlString;
use Ignite\Core\Models\Grid\Formatter;

class MenuFormatter extends Formatter
{
    /**
     * Format a checkbox for selecting entries in the grid.
     *
     * @param  \Ignite\Catalog\Entities\Menu $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        return $this->formatCheckbox($model->getKey());
    }

    /**
     * Custom column for actions.
     *
     * @param  \Ignite\Catalog\Entities\Menu $model
     * @return HtmlString
     */
    public function actions($model)
    {
        $actions = [
            [
                'icon' => 'pencil',
                'label' => trans('Core::core.buttons.edit'),
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.menus.edit', [
                    'attribute' => $model->getKey()
                ])
            ], [
                'icon' => 'eye',
                'label' => trans('Core::core.buttons.view'),
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.menus.show', [
                    'attribute' => $model->getKey()
                ])
            ],
        ];

        return $this->html($this->buttons($actions));
    }

    /**
     * Format the catalog with a link to the correct catalog resource.
     *
     * @param  \Ignite\Catalog\Entities\Menu $model
     * @return HtmlString
     */
    public function catalog($model)
    {
        return $this->html(sprintf(
            '<a href="%s">%s</a>',
            route('admin.catalog.vendors.show', $model),
            $model->catalog->name
        ));
    }

    /**
     * Format whether an order has been processed.
     *
     * @param  \Ignite\Catalog\Entities\Menu $model
     * @return HtmlString
     */
    public function active($model)
    {
        return $this->html($this->formatYesNo(optional($model)->active));
    }
}
