<?php

namespace Ignite\Catalog\Entities;

use Illuminate\Database\Eloquent\Model;

class MenuItem extends Model
{
    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    /** @var string */
    protected $table = 'catalog_menu_item';

    /** @var string */
    protected $primaryKey = 'id';

    /** @var array */
    protected $guarded = [];

    /**
     * The relationship to the menu.
     *
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function menu()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\Menu::class, 'catalog_menu_id', 'id');
    }

    /**
     * The count of items for the menu item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function associated()
    {
        return $this->belongsToMany(\Ignite\Catalog\Entities\Item::class, 'catalog_category_item', 'item_id', 'category_id');
//                    ->where('active', 1)
//                    ->where('vendor_active', 1)
//                    ->where('visibility', 1);
    }

    /**
     * The relationship to the category.
     *
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function category()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\Category::class, 'catalog_category_id', 'id');
    }

    /**
     * The parent item, if any.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function parent()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\MenuItem::class, 'parent_id', $this->getKeyName());
    }

    /**
     * The child items of this item, if any.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function children()
    {
        return $this->hasMany(\Ignite\Catalog\Entities\MenuItem::class, 'parent_id', $this->getKeyName());
    }

    /**
     * Check if item is root.
     *
     * @return bool
     */
    public function isRoot()
    {
        return (empty($this->parent_id)) ? true : false;
    }

    /**
     * Determine if we've already loaded the children. Used to prevent lazy loading on children
     *
     * @return bool
     */
    public function isChildrenLoaded()
    {
        return isset($this->relations['children']);
    }
}
