<?php

namespace Ignite\Catalog\Tests\Unit\Models\Hawk\Response;

use Illuminate\Foundation\Testing\RefreshDatabase;
//use Ignite\Catalog\Exceptions\ResponseException;
use Ignite\Catalog\Models\Hawk\Response\ErrorResponse;
use Ignite\Tests\TestCase;
use Psr\Http\Message\ResponseInterface;

class ErrorResponseTest extends TestCase
{
    use RefreshDatabase;

    /**
     * @var array
     */
    protected $data = [
        'errors' => [
            ['The first error']
        ],
        'additionalInfo' => [
            ['The first info']
        ]
    ];

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_transform_response_body_into_an_error_response_object()
    {
        $mock = \Mockery::mock(ResponseInterface::class);
        $mock->shouldReceive('getBody')->andReturn(json_encode($this->data));

        $response = ErrorResponse::fromHttpResponse($mock);

        $this->assertSame($this->data, $response->toArray());
        $this->assertTrue($response->hasErrors());
    }

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_will_throw_an_set_the_data_as_errors_if_the_response_has_no_errors_key()
    {
        $data = $this->data;

        unset($data['errors']);

        $data['foo'] = 'bar';

        $mock = \Mockery::mock(ResponseInterface::class);
        $mock->shouldReceive('getStatusCode')->andReturn(200);
        $mock->shouldReceive('getReasonPhrase')->andReturn('');
        $mock->shouldReceive('getBody')->andReturn(json_encode($data));

        $response = ErrorResponse::fromHttpResponse($mock);

        $this->assertArrayHasKey('foo', $response->getErrors());
    }

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_return_errors()
    {
        $response = new ErrorResponse($this->data['errors']);

        $this->assertEquals($this->data['errors'], $response->getErrors());
    }

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_return_additional_info()
    {
        $response = new ErrorResponse($this->data['errors'], $this->data['additionalInfo']);

        $this->assertEquals($this->data['additionalInfo'], $response->getAdditionalInfo());
    }
}