<?php

namespace Ignite\Catalog\Models\Product\Types;

use Ignite\Catalog\Models\Product\Type;
use Ignite\Core\Facades\Format;

class Configurable extends Type
{
    /** @var \Illuminate\Support\Collection */
    protected $options;

    /**
     * The min max range of points for the configurable item.
     *
     * @return string
     */
    public function getPointsRange()
    {
        if ($this->item->points_max === $this->item->points_min) {
            return Format::amount($this->item->points_max);
        }

        return new \Illuminate\Support\HtmlString(
            Format::amount($this->getItem()->points_min) . ' <span class="points__dash">&ndash;</span> ' . Format::amount($this->item->points_max)
        );
    }

    /**
     * Determine if the configurable item has attributes.
     *
     * @return int
     */
    public function hasAttributes()
    {
        $options = $this->getOptions();

        return $options->count();
    }

    /**
     * Get the attributes.
     *
     * @return \Illuminate\Support\Collection
     */
    public function getAttributes()
    {
        $options = $this->getOptions();

        return $options;
    }

    /**
     * Determine if the configurable item has options.
     *
     * @return int
     */
    public function hasOptions()
    {
        return $this->getOptions()->count();
    }

    /**
     * Get the options for the configurable item.
     *
     * @return \Illuminate\Support\Collection
     */
    public function getOptions()
    {
       if (! $this->options) {
            if (! $this->item->relationLoaded('options')) {
                $this->item->load('options');
            }
            $this->options = $this->item->options->groupBy('attribute_id')->sortBy('position');
        }

        return $this->options;
    }
}
