<?php

namespace Ignite\Catalog\Models\Dashboard\Charts;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Ignite\Core\Models\Dashboard\CorrelatedStat;

class OrdersProcessingStat extends CorrelatedStat
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Orders Processing',
            'color' => 'yellow',
            'icon'  => 'ion ion-ios-stopwatch-outline',
            'link'  => url('/admin/catalog/orders/processing'),
            'sort'  => 2
        ], $attributes);

        parent::__construct($attributes);
    }


    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'orders-processing-correlated-stat';
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * Get the correct data value from storage.
     *
     * @return mixed
     */
    public function getData()
    {
        if (! $this->get('data', false)) {
            /**
             * @var Carbon $start
             * @var Carbon $end
             */
            list($start, $end) = $this->getDateRange();
            $this->attributes['data'] = $this->calculateAmount($start, $end);
            $this->attributes['total'] = $this->calculateTotal($start, $end);
            $this->attributes['percentage'] = $this->calculatePercentage();
        }

        return $this->get('data');
    }

    /**
     * Calculate the amount.
     *
     * @param  Carbon $start
     * @param  Carbon $end
     * @return int
     */
    protected function calculateAmount(Carbon $start, Carbon $end)
    {
        return DB::query()
          ->select(DB::raw('COUNT(id) as total'))
          ->from('catalog_order_item')
          ->where('processed', '=', '0')
          ->whereNull('cancelled_at')
          ->whereBetween('created_at', [$start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')])
          ->count();
    }

    /**
     * Calculate the total.
     *
     * @param  Carbon $start
     * @param  Carbon $end
     * @return int
     */
    protected function calculateTotal(Carbon $start, Carbon $end)
    {
        return DB::query()
          ->select(DB::raw('COUNT(id) as total'))
          ->from('catalog_order_item')
          ->whereBetween('created_at', [$start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')])
          ->count();
    }
}
