<?php

namespace Ignite\Catalog\Console;

use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Collection;
use Ignite\Catalog\Contracts\OrderRepository;
use Ignite\Catalog\Entities\OrderItem;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;

class OrderVendorCheck extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'ignite:catalog:order-vendor-check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check all vendor orders in a state of processed to query the order for success.';

    /**
     * Flag to determine if we are in dry run mode.
     *
     * @var bool
     */
    protected $isDryRun;

    /**
     * Positive values for the dry run option.
     *
     * @var array
     */
    protected $positiveValues = [
        true, 'true', 1, '1', 'yes', 'y', null
    ];

    /**
     * Execute the console command.
     *
     * @param OrderRepository $orderRepository
     * @return mixed
     */
    public function handle(OrderRepository $orderRepository)
    {
        $orders = $this->getProcessedOrderItems();
    }

    protected function getProcessedOrders()
    {
        return OrderItem::processed()->withoutVendorOrder();
    }

    /**
     * Determine if user asked for a dry run.
     *
     * @return bool
     */
    protected function isDryRun()
    {
        if (is_null($this->isDryRun)) {
            $this->isDryRun = in_array($this->option('dry-run'), $this->positiveValues, true);
        }
        return $this->isDryRun;
    }

    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return [];
    }

    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        return [
            ['send-email', null, InputOption::VALUE_OPTIONAL, 'Should we send an email?', null],
            ['dry-run', null, InputOption::VALUE_OPTIONAL, 'Should we run the import or dry-run it?', false]
        ];
    }

    /**
     * Handle an exception depending on the command verbosity.
     *
     * @param $e
     */
    protected function handleException($e)
    {
        if ($this->output->isVerbose() || $this->output->isVeryVerbose() || $this->output->isDebug()) {
            throw $e;
        }

        $this->error(
            sprintf('An error occurred: %s in %s on line %s', $e->getMessage(), $e->getFile(), $e->getLine())
        );
    }
}
