<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Support\HtmlString;
use Ignite\Catalog\Entities\Item;
use Ignite\Core\Models\Grid\Formatter;

class CatalogItemFormatter extends Formatter
{
    /**
     * Custom column for actions.
     *
     * @param  Item $item
     * @return HtmlString
     */
    public function actions(Item $item)
    {
        $actions = [
            [
                'click' => '',
                'class' => '',
                'icon' => 'eye',
                'label' => 'View',
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.items.show', [
                    'number' => $item->id
                ])
            ]
        ];

        return $this->html($this->buttons($actions));
    }

    /**
     * Format a catalog name with a link.
     *
     * @param  Item $model
     * @return HtmlString
     */
    public function name($model)
    {
        return $this->html(sprintf('<a href="%s">%s</a>', route('admin.catalog.items.show', $model->getKey()), $model->name));
    }

    /**
     * Format whether the item is active.
     *
     * @param  Item $model
     * @return HtmlString
     */
    public function active(Item $model)
    {
        return $this->html($this->formatYesNo(optional($model)->active));
    }

    /**
     * Format the related vendor.
     *
     * @param  Item $model
     * @return HtmlString
     */
    public function vendor(Item $model)
    {
        return $this->html($model->vendor->name);
    }
}
