<?php

namespace Ignite\Catalog\Entities;

use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    /** @var string */
    protected $primaryKey = 'id';

    /** @var string */
    protected $table = 'catalog_cart_item';

    /**
     * The relationship to the user.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(\Ignite\Core\Entities\User::class, 'user_id', 'user_id');
    }

    /**
     * The relationship to the cart line items.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function items()
    {
        return $this->hasMany(\Ignite\Catalog\Entities\CartItem::class, 'catalog_cart_id', 'id');
    }
}
