<?php

namespace Ignite\Catalog\Vendors;

trait TracksRequestAttempts
{
    /**
     * The local cache of attempts as an associative array with the function name as the key and an int as value.
     * @var array
     */
    protected $attempts = [];

    /**
     * Set the number of attempts for the given function.
     *
     * @param  string $function
     * @param  int    $number
     * @return $this
     */
    protected function setAttempts($function, $number)
    {
        $this->attempts[$function] = $number;

        return $this;
    }

    /**
     * Get the number of attempts for the given function.
     *
     * @param  string $function
     * @return int
     */
    protected function getAttempts($function)
    {
        return $this->attempts[$function];
    }

    /**
     * Increment the number of attempts to process the API call during the current request.
     *
     * @param  string $function
     * @return $this
     */
    protected function incrementAttempts($function)
    {
        if (! isset($this->attempts[$function])) {
            $this->attempts[$function] = 0;
        }

        $this->attempts[$function]++;

        return $this;
    }
}
