@extends('Core::layouts.main')

@section('meta_title', 'Catalog Management')

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.catalog.index') }}">Catalog Management</a></small>
    </h1>
@endsection

@section('breadcrumb')
    @parent
    <li><a href="{{ route('admin.catalog.index') }}">Catalog</a></li>
    @php
    $submodule = request()->segment(3);
    $submodules = ['vendors', 'orders', 'categories', 'attributes', 'menus', 'items'];
    @endphp
    @if (in_array($submodule, $submodules) && !empty(request()->segment(4)))
    <li><a href="{{ route("admin.catalog.$submodule.index") }}">{{ ucwords($submodule) }}</a></li>
    @endif
    <li class="active">@yield('page_breadcrumb')</li>
@endsection
