<?php

namespace Ignite\Catalog\Entities;

use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    /** @var string */
    protected $table = 'catalog_menu';

    /** @var string */
    protected $primaryKey = 'id';

    /** @var array */
    protected $guarded = [];

    /**
     * The relationship to the catalog.
     *
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function catalog()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\Catalog::class, 'catalog_id', 'id');
    }

    /**
     * The relationship to the menu items.
     *
     * @return \Illuminate\Database\Eloquent\Relations\hasMany
     */
    public function associated()
    {
        return $this->hasMany(\Ignite\Catalog\Entities\MenuItem::class, 'catalog_menu_id', 'id');
    }

    /**
     * The relationship to the menu items.
     *
     * @return \Illuminate\Database\Eloquent\Relations\hasMany
     */
    public function items()
    {
        return $this->hasMany(\Ignite\Catalog\Entities\MenuItem::class, 'catalog_menu_id', 'id')
            ->where('parent_id', 0)
            ->where('active', 1)
            ->orderBy('position', 'asc');
    }

    /**
     * Detach and attach the associated items for the menu.
     *
     * @param  array  $models
     * @return $this
     */
    public function syncItems(array $models)
    {
        $this->associated()->delete();
        $this->associated()->saveMany($models);

        return $this;
    }

    /**
     * The array of presentable data for the view.
     *
     * @return array
     */
    public function toPresentableArray()
    {
        return [
            'name' => $this->name,
            'catalog' => $this->catalog->name,
            'active' => $this->active ? 'Yes' : 'No'
        ];
    }
}
