<?php

namespace Ignite\Catalog\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Ignite\Catalog\Models\Grid\ParticipantOrderTable;
use Ignite\Core\Contracts\Repositories\ParticipantRepository;
use Ignite\Core\Http\Controllers\Controller;

class ParticipantOrdersController extends Controller
{
    /**
     * @var ParticipantRepository
     */
    private $participantRepository;

    /**
     * ParticipantOrdersController constructor.
     *
     * @param ParticipantRepository $participantRepository
     */
    public function __construct(ParticipantRepository $participantRepository)
    {
        $this->participantRepository = $participantRepository;
    }

    /**
     * Show the Claim that belong to the provided participant.
     *
     * @param  bool|int              $participantId
     * @param  ParticipantOrderTable $table
     * @param  Request               $request
     * @return \Illuminate\Http\JsonResponse|\Illuminate\View\View
     * @throws \Ignite\Packages\Presenter\Exceptions\PresenterException
     */
    public function index($participantId, ParticipantOrderTable $table, Request $request)
    {
        $participant = $this->participantRepository->find($participantId)->present();
        $table->with('user_id', $participantId);

        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Catalog::admin.participant.orders.index', compact(
            'participant',
            'participantId'
        ));
    }
}
