<?php

namespace Ignite\Catalog\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;

class OrderChecked extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var Collection
     */
    public $orderItems;

    /**
     * Create a new message instance.
     *
     * @param Collection $orderItems
     */
    public function __construct(Collection $orderItems)
    {
        $this->orderItems = $orderItems;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $this->to(config('mail.from.address'), config('mail.from.name'));
        $this->subject('Orders check: ' . now()->format('Y-m-d H:ia'));
        $this->from(config('mail.from.address'), config('mail.from.name'));

        return $this->markdown('emails.orders.checked');
    }
}
