@extends('Catalog::layouts.master')

@section('page_breadcrumb', trans('Catalog::order.misc.index.heading'))

@section('page_heading', trans('Catalog::order.misc.index.heading'))

@php
$labels = [
    'all' => 'primary',
    'processing' => 'warning',
    'processed'  => 'success',
    'cancelled'  => 'danger',
];
@endphp

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <form id="orders-delete-form" action="{{ route('admin.catalog.orders.destroyMany') }}" method="post">
                {{ csrf_field() }}
                {{ method_field('DELETE') }}
                <input type="hidden" name="ids" value="" id="orders-delete-field" />
            </form>
            <form id="orders-cancel-form" action="{{ route('admin.catalog.orders.cancelMany') }}" method="post">
                {{ csrf_field() }}
                <input type="hidden" name="ids" value="" id="orders-cancel-field" />
            </form>
            <form id="orders-process-form" action="{{ route('admin.catalog.orders.processMany') }}" method="post">
                {{ csrf_field() }}
                <input type="hidden" name="ids" value="" id="orders-process-field" />
            </form>
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    @foreach($tabs as $key => $tab)
                        <li class="{{ ($status == $key) ? 'active' : '' }}">
                            <a href="{{ route('admin.catalog.orders.index', ['status' => $key]) }}">{{ $tab['label'] }} <span class="label label-{{ $labels[$key] }}">{{ $tab['count'] }}</span></a>
                        </li>
                    @endforeach
                </ul>
                <div class="tab-content">
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    enabled: false,
                    text: '<span class="fa fa-trash text-danger"></span> <span class="text-danger">Delete</span>',
                    action: function (e, dt, node, conf) {
                        var selected = dt.column(0).checkboxes.selected();
                        var message = '{{ trans('Catalog::order.delete_many.confirm') }}';
                        if (confirm(message)) {
                            $('#orders-delete-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                            $('#orders-delete-form').submit();
                        }
                    }
                }, {
                  enabled: false,
                  text: '<span class="fa fa-ban text-danger"></span> <span class="text-danger">Mark all Cancelled</span>',
                  action: function (e, dt, node, conf) {
                    var selected = dt.column(0).checkboxes.selected();
                    var message = "Are you sure you want to mark all of these orders as cancelled?";
                    if (confirm(message)) {
                      $('#orders-cancel-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                      $('#orders-cancel-form').submit();
                    }
                  }
                }, {
                  enabled: false,
                  text: '<span class="fa fa-check text-success"></span> <span class="text-success">Mark all Processed</span>',
                  action: function (e, dt, node, conf) {
                    var selected = dt.column(0).checkboxes.selected();
                    var message = "Are you sure you want to mark all of these orders as processed?";
                    if (confirm(message)) {
                      $('#orders-process-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                      $('#orders-process-form').submit();
                    }
                  }
                }]
            });
        });
    </script>
@endsection
