<?php

namespace Ignite\Catalog\Providers;

use Illuminate\Support\ServiceProvider;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Frontend Navigation Menu
        view()->composer('partials._catalog.buttons', \Ignite\Catalog\Http\Views\CatalogCountsComposer::class);

        view()->composer('partials._components.points', \Ignite\Catalog\Http\Views\PointsTotalComposer::class);

        view()->composer('partials._catalog.filters.categories', \Ignite\Catalog\Http\Views\CategoriesComposer::class);

        view()->composer('partials._catalog.checkout.form', \Ignite\Catalog\Http\Views\CheckoutFormComposer::class);

        view()->composer('catalog.order.index', \Ignite\Catalog\Http\Views\OrderSummaryComposer::class);
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
