<?php

namespace Ignite\Catalog\Events\Handlers\Participants;

use Ignite\Catalog\Entities\Cart;
use Ignite\Catalog\Entities\Favorite;
use Ignite\Catalog\Entities\Order;
use Ignite\Catalog\Entities\OrderItem;
use Ignite\Core\Events\EnrollmentDeleting;

class DeleteCatalogRelationsWhenDeletingParticipant
{
    /**
     * Handle deleting catalog orders and order items related to the participant being deleted.
     *
     * @param EnrollmentDeleting $event
     */
    public function handle(EnrollmentDeleting $event)
    {
        $participant = $event->getParticipant();
        $participantId = $participant->getKey();

        OrderItem::query()
            ->leftJoin('catalog_order', 'catalog_order.id', '=', 'catalog_order_item.catalog_order_id')
            ->where('catalog_order.user_id', $participantId)->delete();
        Order::query()->where('user_id', $participantId)->delete();
        Cart::query()->where('user_id', $participantId)->delete();
        Favorite::query()->where('user_id', $participantId)->delete();
    }
}
