<?php

namespace Ignite\Catalog\Tests\Unit\Models\Options;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Ignite\Catalog\Models\Options\Catalog;
use Ignite\Tests\TestCase;

class CatalogTest extends TestCase
{
    use RefreshDatabase;

    public function setUp()
    {
        parent::setUp();

        $this->loadHelpers();
    }

    /**
     * @test
     * @group Catalog
     * @group Options
     * @group Source
     */
    public function it_will_return_an_empty_array_when_no_catalog_records_exist()
    {
        $sourceModel = new Catalog();

        $this->assertEmpty($sourceModel->toDropdown());
    }

    /**
     * @test
     * @group Catalog
     * @group Options
     * @group Source
     */
    public function it_will_return_the_catalog_records_as_key_value_pair_for_use_in_a_dropdown()
    {
        $sourceModel = new Catalog();

        $vendor = factory(\Ignite\Catalog\Entities\Vendor::class)->create();
        $catalog = factory(\Ignite\Catalog\Entities\Catalog::class)->create([
            'catalog_vendor_id' => $vendor->getKey()
        ]);

        $this->assertArrayHasKey($catalog->getKey(), $sourceModel->toDropdown());
        $this->assertContains($catalog->name, $sourceModel->toDropdown());
    }
}
