@extends('Catalog::layouts.master')

@section('page_heading', trans('Catalog::menu.misc.edit.heading', ['name' => $menu->name]))
@section('page_breadcrumb', trans('Catalog::menu.misc.edit.heading', ['name' => $menu->name]))

@section('css')
    @parent
    <link rel="stylesheet" href="{{ asset('/vendor/ignite/js/vendor/jqtree/jqtree.css') }}" />
@endsection

@section('page_content')
    <div class="row" id="page">
        @include('Catalog::admin._partials.menus.menu')

        <div class="col-sm-9">
            <div class="box box-primary">
                <div class="overlay" id="loading">
                    <i class="fa fa-refresh fa-spin"></i>
                </div>
                <div class="box-body">
                    {!! form_start($form) !!}

                    {!! form_row($form->name) !!}
                    {!! form_row($form->catalog_id) !!}
                    {!! form_row($form->active) !!}

                    <hr />

                    <div class="row">
                        <div class="col-sm-6">
                            <div id="menu-tree"></div>
                            <hr />
                            <div id="node-selector" class="input-group hide">
                                <span class="input-group-addon"><span class="fa fa-plus"></span></span>
                                <select id="node-add-category" class="form-control">
                                    <option></option>
                                </select>
                                <span class="input-group-btn">
                                    <button id="node-add-action" class="btn btn-default" type="button">
                                        {{ trans('Core::core.buttons.add') }}
                                    </button>
                                </span>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div id="node-form" class="panel panel-default hide">
                                <div class="panel-heading">
                                    <h4 class="no-margin">{{ trans('Core::core.buttons.update') }} <span id="node-name">{node}</span></h4>
                                </div>
                                <div class="form-group panel-body no-margin">
                                    <label for="node-active" class="control-label col-sm-4">{{ trans('Catalog::menu.fields.active.label') }}</label>
                                    <div class="col-sm-8">
                                        <input type="checkbox" name="active" value="1" id="node-active" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr />

                    {!! form_rest($form) !!}

                    {!! form_end($form, false) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="{{ asset('/vendor/ignite/js/vendor/jqtree/tree.jquery.js') }}"></script>
    <script src="{{ asset('/vendor/ignite/js/catalog/menus.js') }}"></script>
    <script>
      jQuery(function($) {
        $.ajax("{{ route('api.catalog.menus.categories', $menu) }}").then(function (categories) {
          var $category = $('#node-add-category');
          $category.select2({
            placeholder: "{{ trans('Catalog::menu.misc.edit.category.choose') }}",
            data: categories,
            language: {
              noResults: function() {
                return "{{ trans('Catalog::menu.misc.edit.category.no_results') }}";
              }
            },
          });
          $('#node-selector').removeClass('hide');
          $('#loading').addClass('hide');
          $('#menu-tree').menuManager({
            token: "{{ csrf_token() }}",
            menuId: {{ $menu->getKey() }},
            itemsField: '#associated',
            loadUrl: "{{ route('api.catalog.menus.items', $menu) }}",
          });
        });
      });
    </script>
@endsection
