<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCatalogFavoriteTable extends Migration
{
    protected $tableName = 'catalog_favorite';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id');
            $table->unsignedInteger('super_id')->nullable()->default();
            $table->unsignedInteger('item_id');
            $table->timestamps();
            $table->foreign('user_id')->references('user_id')->on('core_user');
            $table->foreign('super_id')->references('id')->on('catalog_item');
            $table->foreign('item_id')->references('id')->on('catalog_item');
            $table->unique(['id', 'item_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
