<?php

namespace Ignite\Catalog\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Ignite\Catalog\Models\Cart;

class OrderCreateRequest extends FormRequest
{
    /**
     * Authorize the order create request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @param  Cart $cart
     * @return array
     */
    public function rules(Cart $cart)
    {
        $rules = [
            'first' => 'required',
            'last' => 'required',
            'ship_phone' => 'required'
        ];

        if ($cart->hasNonPhysical()) {
            $rules['ship_email'] = 'required|email';
        }

        if ($cart->hasPhysical()) {
            $rules['ship_address_1'] = 'required';
            $rules['ship_city'] = 'required';
            $rules['ship_state'] = 'required';
            $rules['ship_postal'] = 'required';
        }

        return $rules;
    }

    /**
     * The customized messages.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'first.required' => 'First name is required',
            'last.required'  => 'Last name is required',
            'email.required'  => 'The email address to send the eGift is required',
            'email.email'  => 'The email address to send the eGift must be valid',
            'ship_phone.required'  => 'Phone number is required',
            'ship_phone.numeric'  => 'Phone number must be numeric',
            'ship_address_1.required'  => 'The address line 1 is required',
            'ship_address_2.required'  => 'The address line 2 is required',
            'ship_city.required'  => 'The city is required',
            'ship_state.required'  => 'The state is required',
            'ship_postal.required'  => 'The postal code/zip is required',
        ];
    }
}
