<?php

namespace Ignite\Catalog\Http\Controllers;

use Ignite\Core\Http\Controllers\Controller;
use Ignite\Catalog\Contracts\OrderRepository;
use Ignite\Catalog\Models\Cart;

class OrderController extends Controller
{
    /**
     * @var OrderRepository
     */
    protected $orderRepository;

    /**
     * Create a new controller instance.
     *
     * @param OrderRepository $orderRepository
     */
    public function __construct(OrderRepository $orderRepository)
    {
        $this->orderRepository = $orderRepository;
    }

    /**
     * Display an Order and it's details.
     *
     * @param  Cart $cart
     * @return \Illuminate\Http\Response
     */
    public function index(Cart $cart)
    {
        $orders = $this->orderRepository->findAllByUser(auth()->user()->getKey());
        $balance = $cart->balance();

        return view('catalog.order.index', compact('orders', 'balance'));
    }

    /**
     * Display an Order and it's details
     *
     * @param  string $number
     * @return \Illuminate\Http\Response
     */
    public function show($number)
    {
        $order = $this->orderRepository->find($number);

        return view('catalog.order.show', compact('order'));
    }
}
