<?php

namespace Ignite\Catalog\Providers;

use Ignite\Catalog\Console\Brightspot;
use Ignite\Catalog\Console\Hawk;
use Ignite\Catalog\Console\OrderCheck;
use Illuminate\Support\ServiceProvider;

class ConsoleServiceProvider extends ServiceProvider
{
    protected $defer = false;

    /**
     * The available commands
     *
     * @var array
     */
    protected $commands = [
        Hawk::class,
        Brightspot::class,
        OrderCheck::class,
    ];

    /**
     * Register the commands.
     */
    public function register()
    {
        $this->commands($this->commands);
    }

    /**
     * The classes the provider provides.
     *
     * @return array
     */
    public function provides()
    {
        $provides = $this->commands;

        return $provides;
    }
}

