<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
//use Ignite\Core\Database\IgniteMigration;

class CreateCatalogOrderTable extends Migration
{
    protected $tableName = 'catalog_order';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id');
            $table->string('number');
            $table->unsignedInteger('quantity');
            $table->unsignedInteger('points');
            $table->string('ship_name', 100);
            $table->string('ship_email', 255)->nullable();
            $table->string('ship_address_1', 100)->nullable();
            $table->string('ship_address_2', 100)->nullable();
            $table->string('ship_address_3', 100)->nullable();
            $table->string('ship_city', 100)->nullable();
            $table->string('ship_state', 100)->nullable();
            $table->string('ship_postal', 50)->nullable();
            $table->string('ship_country', 100)->nullable();
            $table->string('ship_phone', 50);
            $table->text('notes')->nullable();
            $table->integer('processed')->default(0);
            $table->timestamp('processed_at')->nullable();
            $table->integer('cancelled')->default(0);
            $table->timestamp('cancelled_at')->nullable();
            $table->timestamps();
            $table->foreign('user_id')->references('user_id')->on('core_user');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
