<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
//use Ignite\Core\Database\IgniteMigration;

class CreateCatalogMenuTable extends Migration
{
    protected $tableName = 'catalog_menu';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('catalog_id');
            $table->string('name', 255);
            $table->boolean('active')->default(0);
            $table->timestamps();
            $table->foreign('catalog_id')->references('id')->on('catalog');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
