<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
//use Ignite\Core\Database\IgniteMigration;

class CreateCatalogAttributeItemTable extends Migration
{
    protected $tableName = 'catalog_attribute_item';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('attribute_id');
            $table->unsignedInteger('item_id');
            $table->string('value', 255);
            $table->unsignedInteger('position');
            $table->string('type', 100)->nullable()->default('select');
            $table->boolean('active')->default(0);
            $table->timestamps();
            $table->foreign('attribute_id')->references('id')->on('catalog_attribute');
            $table->foreign('item_id')->references('id')->on('catalog_item');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
