<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
//use Ignite\Core\Database\IgniteMigration;

class CreateCatalogAttributeTable extends Migration
{
    protected $tableName = 'catalog_attribute';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->string('label', 100);
            $table->string('code', 50);
            $table->string('type', 100);
            $table->boolean('use_in_filter')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
