<?php

namespace Ignite\Activity\Traits;

use Ignite\Activity\Contracts\TypeStrategyInterface;

trait TypeStrategyClientTrait
{
    /**
     * Returns the strategy class for the activity type, if any.
     *
     * @param  string $type
     * @return TypeStrategyInterface|null
     */
    protected function getTypeStrategy(string $type): ?TypeStrategyInterface
    {
        $strategyClass = 'ActivityStrategy' . ucwords($type);
        if (app()->has($strategyClass)) {
            $strategy = resolve($strategyClass);
            if (!($strategy instanceof TypeStrategyInterface)) {
                throw new \Exception("{$strategyClass} must implement the TypeStrategyInterface interface.");
            }
            return $strategy;
        }

        return null;
    }
}
